/***************************************
  $Header: /home/amb/wwwoffle/RCS/connect.c 1.17 1997/06/13 19:38:21 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 1.2a.
  Handle WWWOFFLE connections received by the demon.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1996,97 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "config.h"
#include "errors.h"


/*+ The server sockets that we listen on +*/
extern int http_fd,             /*+ for the HTTP connections. +*/
           wwwoffle_fd;         /*+ for the WWWOFFLE connections. +*/

/*+ The proxy server that we use. +*/
extern char *proxy;

/*+ The online / offline status. +*/
extern int online;

/*+ The current number active servers +*/
extern int n_servers,           /*+ in total. +*/
           n_fetch_servers;     /*+ fetching a previously requested page. +*/

/*+ The wwwoffle client file descriptor when fetching. +*/
extern int fetch_fd;

/*+ The pids of the servers that are fetching. +*/
extern int fetch_pids[MAX_FETCH_SERVERS];

/*+ The current status, fetching or not. +*/
extern int fetching;


/*++++++++++++++++++++++++++++++++++++++
  Parse a request that comes from wwwoffle.

  FILE *client The file pointer that corresponds to the wwwoffle connection.
  ++++++++++++++++++++++++++++++++++++++*/

void CommandConnect(FILE *client)
{
 char *line=NULL;

 if(!(line=fgets_realloc(line,client)))
   {PrintMessage(Warning,"Nothing to read from the wwwoffle control socket [%!s]."); return;}

 if(strncmp(line,"WWWOFFLE ",9))
   {
    PrintMessage(Warning,"Not a WWWOFFLE command.");
    return;
   }

 if(PassWord || !strncmp(&line[9],"PASSWORD ",9))
   {
    char *password;

    if(strlen(line)<18)
       password="";
    else
      {
       int i;

       for(i=18;line[i];i++)
          if(line[i]=='\r' || line[i]=='\n')
             line[i]=0;

       password=&line[18];
      }

    if(strcmp(password,PassWord))
      {
       char *msg="WWWOFFLE Incorrect Password\n";
       write(fileno(client),msg,strlen(msg));

       PrintMessage(Warning,"Incorrect Password.");

       return;
      }

    if(!(line=fgets_realloc(line,client)))
      {PrintMessage(Warning,"Unexpected end of wwwoffle control command [%!s]."); return;}
   }

 if(!strncmp(&line[9],"ONLINE",6))
   {
    char *msg;

    if(online)
       msg="WWWOFFLE Already Online\n";
    else
       msg="WWWOFFLE Now Online\n";

    write(fileno(client),msg,strlen(msg));

    if(!online)
       PrintMessage(Important,"WWWOFFLE Online.");

    online=1;
   }
 else if(!strncmp(&line[9],"OFFLINE",7))
   {
    char *msg;

    if(!online)
       msg="WWWOFFLE Already Offline\n";
    else
       msg="WWWOFFLE Now Offline\n";

    write(fileno(client),msg,strlen(msg));

    if(online)
       PrintMessage(Important,"WWWOFFLE Offline.");

    online=0;
   }
 else if(!strncmp(&line[9],"FETCH",5))
   {
    char *msg;

    if(fetch_fd!=-1)
       msg="WWWOFFLE Already fetching.\n";
    else if(!online)
       msg="WWWOFFLE Must be online to fetch.\n";
    else
       msg="WWWOFFLE Now Fetching.\n";

    write(fileno(client),msg,strlen(msg));

    PrintMessage(Important,"WWWOFFLE Fetch.");

    if(fetch_fd==-1 && online)
      {
       int n_start;

       fetch_fd=fileno(client);
       fetching=1;

       if((MAX_SERVERS-n_servers)>(MAX_FETCH_SERVERS-n_fetch_servers))
          n_start=(MAX_FETCH_SERVERS-n_fetch_servers);
       else
          n_start=(MAX_SERVERS-n_servers);

       for(;n_start;n_start--)
          ForkServer(fetch_fd,0);
      }
   }
 else if(!strncmp(&line[9],"CONFIG",6))
   {
    char *msg="WWWOFFLE Reading Configuration File.\n";
    write(fileno(client),msg,strlen(msg));

    PrintMessage(Important,"WWWOFFLE Re-reading Configuration File.");

    if(ReadConfigFile(fileno(client)))
      {
       PrintMessage(Warning,"Error in configuration file; keeping old values.");

       msg="WWWOFFLE Error Reading Configuration File.\n";
      }
    else
       msg="WWWOFFLE Read Configuration File.\n";

    write(fileno(client),msg,strlen(msg));

    PrintMessage(Important,"WWWOFFLE Finished Re-reading Configuration File.");
   }
 else if(!strncmp(&line[9],"PURGE",5))
   {
    char *msg="WWWOFFLE Purge Starting.\n";
    write(fileno(client),msg,strlen(msg));

    if(PurgeUseMTime)
       msg="(Using modification time.)\n";
    else
       msg="(Using last access time.)\n";
    write(fileno(client),msg,strlen(msg));

    PrintMessage(Important,"WWWOFFLE Purge.");

    PurgeCache(fileno(client));

    msg="WWWOFFLE Purge Finished.\n";
    write(fileno(client),msg,strlen(msg));

    PrintMessage(Important,"WWWOFFLE Purge finished.");
   }
 else
   {
    char *msg=(char*)malloc(strlen(line)+32);

    while(line[strlen(line)-1]=='\r' || line[strlen(line)-1]=='\n')
       line[strlen(line)-1]=0;

    PrintMessage(Warning,"Unknown WWWOFFLE control command '%s'.",line);

    sprintf(msg,"WWWOFFLE Unknown Command '%s'.",line);
    write(fileno(client),msg,strlen(msg));

    free(msg);
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Fork a server.

  int client The file descriptor that the data comes in on.

  int browser Set to true if there is a browser connection.
  ++++++++++++++++++++++++++++++++++++++*/

void ForkServer(int client,int browser)
{
 int pid;

 if((pid=fork())==-1)
    PrintMessage(Warning,"Cannot fork a server [%!s].");
 else
   {
    if(pid)                      /* The parent */
      {
       n_servers++;

       if(online && !browser)
         {
          int i;

          for(i=0;i<MAX_FETCH_SERVERS;i++)
             if(fetch_pids[i]==0)
               {fetch_pids[i]=pid;break;}

          n_fetch_servers++;
         }

       PrintMessage(Inform,"Forked wwwoffles -%s (pid=%d).",online?browser?"real":"fetch":"spool",pid);
      }
    else                         /* The child */
      {
       int status;

       if(fetch_fd!=-1 && fetch_fd!=client)
          close(fetch_fd);

       close(http_fd);
       close(wwwoffle_fd);

       status=wwwoffles(online,browser,client);

       exit(status);
      }
   }
}
